//---------------------------------------------------------------------------
#ifndef UTabelaH
#define UTabelaH

#include <vcl.h>
#include <ADODB.hpp>

#include "URekord.h"

//---------------------------------------------------------------------------
class MTabela : public TObject
{
protected:
   Longint         IlRek;                                                       // ustawiane przez Get_Reccount();
   AnsiString      sql_txt;                                                     // do przechowywania treci zapytania
	TADOConnection *ADOConnection;                                               // przekaza wskanik do odpowiedniego z DataModule w UDM.pas


public:
   TADOQuery *LQ;                                                               // Local Query do wykonywania zapyta

   bool    Eof();                                                               // czy Eof() kursora
   void    First();                                                             // ustaw sie na 1 rekordzie kursora
   void    Next();                                                              // przejd do nastepnego rekordu
   void    Close();                                                             // zamknij LQ (LocalQuery)
   Longint RecordCount();                                                       // ilo rekordw kursora

	// wykonaj zapytanie SQL typu Select - zwracajce kursor
   bool Open();

   // wykonaj zapytanie SQL typu ExecSQL
   bool ExecSQL(bool WlaczycTransakcje = false);
   
   virtual bool DajWszystko() = 0;
   virtual void GetRec() = 0;                                                   // pobierz jeden wiersz tabeli do rekordu Rek
   virtual bool Insert(MRekord *rec) = 0;
   virtual bool Edit(MRekord *rec) = 0;
   virtual bool Delete(int Id) = 0;

   __fastcall  MTabela();
   virtual __fastcall ~MTabela();
};
//---------------------------------------------------------------------------
#endif

